﻿using System;
using System.Web.Mvc;
using BMS.Web.Models;
using System.Xml.Serialization;
using System.IO;
using System.Text;
using System.Linq;
using System.Collections.Generic;
using System.Web.Script.Serialization;
using BMS.Facade;
using VI = BMS.VistaIntegration.FacadeContracts;
using BMS.Facade.Data;
using InfoWorld.HL7.ITS;
using System.Text.RegularExpressions;
using Microsoft.Web.Mvc;
using System.ServiceModel;
using BMS.Web.App_GlobalResource;
using BMS.Utils;
using BMS.VistaIntegration.FacadeContracts.Admin;
using BMS.Facade.Service;
using BMS.Web.Controllers.Shared;

namespace BMS.Web.Controllers
{
    [ValidateInput(false)]
    public class NumiController : BaseController
    {                
        [ReadPermissionAuthFilter]
        public ActionResult Index()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                ViewBag.NumiSelectedBackgroundColor = Strings.AnchorBackgroundColor;
                NumiViewModel viewModel = new NumiViewModel();
                viewModel.NumiEntries = FacadeManager.ConfigurationInterface.GetNumiEntries(loggedUser.Domain).OrderBy(numiEntry => numiEntry.Calendar.Name).ToList<NumiEntry>();
                viewModel.Calendars = FacadeManager.ConfigurationInterface.GetDefinedCalendars(loggedUser.Domain).Where(s => !viewModel.NumiEntries.Exists(ss => ss.Calendar.Id == s.Id)).OrderBy(jobCal => jobCal.Name).ToList();
                viewModel.LoggedUser = loggedUser;
                return View(viewModel);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        [HttpPost]
        [ReadPermissionAuthFilter]
        public ActionResult Index(NumiViewModel viewModel)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                return this.RedirectToAction(s => s.Add(EncryptQueryString(new string[] { "calendarId" }, new string[] { viewModel.SelectedCalendarId }, loggedUser.Salt)));
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        [ReadPermissionAuthFilter]
        public ActionResult Add(string p)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                NumiEntry newEntry = new NumiEntry();
                newEntry.Calendar = FacadeManager.ConfigurationInterface.GetDefinedCalendars(loggedUser.Domain).Where(s => s.Id == QueryStrings["calendarId"]).Single();
                newEntry.Sites = new List<VistaSite>();
                return EditResult(newEntry);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        [ReadPermissionAuthFilter]
        public ActionResult Edit(string p)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                string calendarId = QueryStrings["calendarId"];
                if (string.IsNullOrEmpty(calendarId))
                {
                    calendarId = TempData["schedulerId"] as string;
                    return this.RedirectToAction(c => c.Edit(EncryptQueryString(new string[] { "calendarId" }, new string[] { calendarId }, loggedUser.Salt)));
                }
                NumiEntry entry = FacadeManager.ConfigurationInterface.GetNumiEntries(loggedUser.Domain).Where(s => s.Calendar.Id == calendarId).Single();
                return EditResult(entry);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        [HttpPost]
        [UpdatePermissionAuthFilter]
        public ActionResult Edit(NumiEntryModel model)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                NumiEntry entry = model.NumiEntry;
                entry.Sites = new List<VistaSite>();
                model.VistASites.Where(s => s.IsChecked).ForEach(s => entry.Sites.Add(s.Item));
                model.LoggedUser = loggedUser;

                if (entry.Sites.Any())
                {
                    List<NumiEntry> existingEntries = FacadeManager.ConfigurationInterface.GetNumiEntries(loggedUser.Domain).ToList<NumiEntry>();
                    List<NumiEntry> dublicatedEntries = new List<NumiEntry>();
                    if (existingEntries != null || existingEntries.Count != 0)
                    {

                        foreach (NumiEntry existingEntry in existingEntries)
                        {
                            dublicatedEntries.AddRange((from existingVistaSite in existingEntry.Sites
                                                        where (from newEntry in entry.Sites select newEntry.Id.extension).Contains(existingVistaSite.Id.extension)
                                                        select new NumiEntry
                                                        {
                                                            Calendar = existingEntry.Calendar,
                                                            Sites = new List<VistaSite>() { new VistaSite { Code = existingVistaSite.Code, Id = existingVistaSite.Id, Name = existingVistaSite.Name } }
                                                        }));
                        }

                        NumiEntry editExistingEntry = existingEntries.Where(a => a.Calendar.Id == model.NumiEntry.Calendar.Id).FirstOrDefault();
                        if (editExistingEntry != null)
                        {
                            dublicatedEntries = (from duplicatedEntry in dublicatedEntries
                                                 where !(from existingVistaSite in editExistingEntry.Sites select existingVistaSite.Id.extension).Contains(duplicatedEntry.Sites[0].Id.extension)
                                                 select duplicatedEntry).ToList();
                        }
                    }

                    if (dublicatedEntries != null && dublicatedEntries.Count != 0)
                    {
                        AntiXssEncoder xss = new AntiXssEncoder();
                        foreach (NumiEntry dublicatedEntry in dublicatedEntries)
                        {                            
                            ModelState.AddModelError("", "A scheduler already exists for vista site " + dublicatedEntry.Sites[0].Name + " (" + xss.Decode(dublicatedEntry.Calendar.Name) + ").");
                        }
                    }
                    else
                    {
                        FacadeManager.ConfigurationInterface.SaveNumiEntry(entry, loggedUser.Domain);
                        return RedirectToAction("Index");
                    }
                }
                else
                {
                    ModelState.AddModelError("", "Select at least one vista site.");
                }
                ViewBag.NumiSelectedBackgroundColor = Strings.AnchorBackgroundColor;
                TempData["schedulerId"] = model.NumiEntry.Calendar.Id;                
                return View(model);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        [ReadPermissionAuthFilter]
        public ViewResult Delete(string p)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                NumiEntryModel model = new NumiEntryModel();
                ViewBag.NumiSelectedBackgroundColor = Strings.AnchorBackgroundColor;
                JobCalendar jobCalendar = new JobCalendar() { Id = QueryStrings["calendarId"] };
                model.NumiEntry = FacadeManager.ConfigurationInterface.GetNumiEntries(loggedUser.Domain).Where(s => s.Calendar.Id == jobCalendar.Id).Single();
                model.LoggedUser = loggedUser;
                return View(model);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        [HttpPost]
        [UpdatePermissionAuthFilter]
        public ActionResult Delete(NumiEntryModel input)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                FacadeManager.ConfigurationInterface.DeleteNumiEntry(input.NumiEntry.Calendar.Id, loggedUser.Domain);
                return RedirectToAction("Index");
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        private ViewResult EditResult(NumiEntry entry)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                ViewBag.NumiSelectedBackgroundColor = Strings.AnchorBackgroundColor;

                NumiEntryModel model = new NumiEntryModel();
                model.NumiEntry = entry;
                model.VistASites = FacadeManager.EntityInterface.GetVistaSites().OrderBy(vistaSite => vistaSite.Name).Select(s => new CheckItem<VistaSite>() { Item = s }).ToList();
                model.VistASites.Where(s => entry.Sites.Exists(ss => ss.Id.extension.Equals(s.Item.Id.extension, StringComparison.InvariantCultureIgnoreCase))).ForEach(s => s.IsChecked = true);
                model.LoggedUser = loggedUser;
                return View("Edit", model);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}